define(["require", "jquery", "twig", "backbone", "underscore", "lib/core/view", "lib/common/fn", "langs/app", 'https://rawgit.com/melanke/Watch.JS/master/src/watch.js'], function () {
    return function () {
        let self = this,
            lead_params = {},
            main_pipeline = AMOCRM.constant('main_pipeline').toString(),
            getStatuses = function () {
                let resp = {},
                    pipelines = AMOCRM.constant('lead_statuses');
                if (pipelines['s_143'] === undefined) {
                    for (let id in pipelines) {
                        resp[id] = [];
                        for (let status_id in pipelines[id].statuses) {
                            if (status_id !== 's_143')
                                resp[id][resp[id].length] = status_id.replace('s_', '')
                        }
                    }
                } else {
                    resp[main_pipeline] = [];
                    for (let status_id in pipelines) {
                        if (status_id !== 's_143')
                            resp[main_pipeline][resp[main_pipeline].length] = status_id.replace('s_', '')
                    }
                }
                return resp;
            },
            getNextStatus = function (e) {
                let statuses = getStatuses()[e.pipeline_id],
                    status_id = e.status_id.toString();
                return (statuses.indexOf(status_id) > -1) ? statuses[statuses.indexOf(status_id) + 1] : undefined;
            },
            loadStyle = function (file_path) {
                if ($('[href="' + self.params.path + '/' + file_path + '"]').length === 0)
                    $('<link>').attr('href', self.params.path + '/' + file_path).attr('rel', 'stylesheet').appendTo("head");
            },
            getGroupId = function (field_name) {
                if (field_name !== 'lead[PRICE]') {
                    field_name = field_name.slice(4, -1);
                    AMOCRM.constant('cf_groups').forEach(function (group) {
                        if (group.fields.indexOf(field_name) > -1) {
                            $('.card-tabs__item[data-id="' + group.id + '"]:not([data-notification])').addClass('gt-next');
                        }
                    });
                } else {
                    $('.card-tabs__item[data-id="default"]:not([data-notification])').addClass('gt-next');
                }
            },
            checkTrigger = function (status_info) {
                $('.gt-next').removeClass('gt-next');
                AMOCRM.data.current_card.validator.check(status_info);
                AMOCRM.data.current_card.validator1.check({
                    pipeline_id: lead_params['lead[PIPELINE_ID]'],
                    status_id: getNextStatus(status_info)
                });
                $('.validation-not-valid, [data-notification]').removeClass('gt-next');
            };
        this.callbacks = {
            render: function () {
                if (AMOCRM.data.current_entity === 'leads' && AMOCRM.data.is_card === true) {
                    loadStyle('style.css');
                    lead_params = AMOCRM.data.current_card.form.model.attributes;
                    lead_params['lead[PIPELINE_ID]'] = lead_params['lead[PIPELINE_ID]'] === undefined ? AMOCRM.constant('main_pipeline').toString() : lead_params['lead[PIPELINE_ID]'];
                    AMOCRM.data.current_card.validator1 = $.extend({c: ['1']}, AMOCRM.data.current_card.validator);
                    AMOCRM.data.current_card.validator.check = function (e) {
                        let t = 0, i = this.model.count();
                        return e = e || {}, e.status_id && this._enabled && (t = this.checkErrors({
                            rules: this.rules,
                            status_id: e.status_id,
                            pipeline_id: e.pipeline_id,
                            form_view: e.form_view,
                            linked: this.linked
                        }), t > 0 && !i && (this.delegateEvents(this._events()))), t
                    };
                    AMOCRM.data.current_card.validator1.setError = function (e, t) {
                        if (t) {
                            getGroupId(e.rule_name);
                            $(e.$form_el).find('[name^="' + e.rule_name + '"]:not(.validation-not-valid)').closest('.linked-form__field').find('.linked-form__field__label').addClass('gt-next')
                        }
                    };
                    checkTrigger({
                        pipeline_id: lead_params['lead[PIPELINE_ID]'],
                        status_id: lead_params['lead[STATUS]']
                    });
                    $('.control--select--list--item').on('click', function () {
                        setTimeout(function () {
                            checkTrigger({
                                pipeline_id: lead_params['lead[PIPELINE_ID]'],
                                status_id: lead_params['lead[STATUS]']
                            });
                        }, 300)
                    });
                    $('.pipeline-select__dropdown__item__label').on('click', function () {
                        setTimeout(function () {
                            checkTrigger({
                                pipeline_id: lead_params['lead[PIPELINE_ID]'],
                                status_id: lead_params['lead[STATUS]']
                            });
                        }, 300)
                    });
                    $('[name="lead[STATUS]"]').on('change', function () {
                        checkTrigger({
                            pipeline_id: lead_params['lead[PIPELINE_ID]'],
                            status_id: lead_params['lead[STATUS]']
                        });
                    })

                    $('.card-fields__fields-block').on('change', '[name="lead[PRICE]"]', function () {
                        checkTrigger({
                            pipeline_id: lead_params['lead[PIPELINE_ID]'],
                            status_id: lead_params['lead[STATUS]']
                        });
                    });

                    $('.card-fields__fields-block').on('keyup', '[name^=CFV]', function () {
                        checkTrigger({
                            pipeline_id: lead_params['lead[PIPELINE_ID]'],
                            status_id: lead_params['lead[STATUS]']
                        });
                    });
                    $('.card-fields__fields-block').on('change', '[name^=CFV]', function () {
                        checkTrigger({
                            pipeline_id: lead_params['lead[PIPELINE_ID]'],
                            status_id: lead_params['lead[STATUS]']
                        });
                    });
                    $('.card-fields__fields-block').on('change', '.control--select--input[name^=CFV]', function () {
                        checkTrigger({
                            pipeline_id: lead_params['lead[PIPELINE_ID]'],
                            status_id: lead_params['lead[STATUS]']
                        });
                    });

                    $('.card-fields__linked-block').on('keyup', '[name^=CFV]', function () {
                        checkTrigger({
                            pipeline_id: lead_params['lead[PIPELINE_ID]'],
                            status_id: lead_params['lead[STATUS]']
                        });
                    });
                    $('.card-fields__linked-block').on('change', '[name^=CFV]', function () {
                        checkTrigger({
                            pipeline_id: lead_params['lead[PIPELINE_ID]'],
                            status_id: lead_params['lead[STATUS]']
                        });
                    });
                    $('.card-fields__linked-block').on('change', '.control--select--input[name^=CFV]', function () {
                        checkTrigger({
                            pipeline_id: lead_params['lead[PIPELINE_ID]'],
                            status_id: lead_params['lead[STATUS]']
                        });
                    });
                    $(document).on('change', '.js-master-checkbox-wrapper.checkboxes_dropdown__checkbox_master', function () {
                        if ($(this).closest('.card-fields__linked-block').length > 0)
                            checkTrigger({
                                pipeline_id: lead_params['lead[PIPELINE_ID]'],
                                status_id: lead_params['lead[STATUS]']
                            });
                        if ($(this).closest('.card-fields__fields-block').length > 0)
                            checkTrigger({
                                pipeline_id: lead_params['lead[PIPELINE_ID]'],
                                status_id: lead_params['lead[STATUS]']
                            });
                    });

                }
                // else
                //                 // {
                //                 //     $('[name="CFV[454575]"]').closest('.linked-form__field').find('.linked-form__field__label').css("font-weight", "bold").css("color", "blue");
                //                 // }
                $('[name="CFV[371763]"]').closest('.linked-form__field').find('.linked-form__field__label').css("font-weight", "bold").css("color", "blue");
                $('.linked-form__field__label').css('width', '55%');
                return true;
            },
            init: function () {
                return true;
            },
            bind_actions: function () {
                return true;
            },
            settings: function () {
                return true;
            },
            onSave: function () {
                alert('click');
                return true;
            },
            destroy: function () {

            },
            contacts: {
                //select contacts in list and clicked on widget name
                selected: function () {
                }
            },
            leads: {
                //select leads in list and clicked on widget name
                selected: function () {
                }
            },
            tasks: {
                //select taks in list and clicked on widget name
                selected: function () {
                }
            }
        };
        return this;
    };
});