define(['jquery'], function($)
{
    return function() {
        let self = this;
        let getEntity = () => AMOCRM.data.current_entity;
        let getCfInfo = () => AMOCRM.constant('account').cf;
        let getDomainUrl = () => self.params.domain_url;
        let getStageFailureFieldId = () => self.params.field_id;
        let getCfStageFailureData = $key => getCfInfo()[getStageFailureFieldId()][$key];
        let getAjaxData = () => { 
            return {
                "action":"apply_changes",
                "cf":
                {
                    "edit":
                    [{
                        "id": getCfStageFailureData('ID'),
                        "name": getCfStageFailureData('NAME'),
                        "type_id": getCfStageFailureData('TYPE_ID'),
                        "account_id": getCfStageFailureData('ACCOUNT_ID'),
                        "description": getCfStageFailureData('DESCRIPTION'),
                        "code": getCfStageFailureData('CODE'),
                        "sort": getCfStageFailureData('SORT'),
                        "entree_catalog": getCfStageFailureData('ENTREE_CATALOG'),
                        "predefined": getCfStageFailureData('PREDEFINED'),
                        "multiple": getCfStageFailureData('MULTIPLE'),
                        "disabled": getCfStageFailureData('DISABLED'),
                        "catalog_id": getCfStageFailureData('CATALOG_ID'),
                        "settings":
                        {
                            "is_deletable": getCfStageFailureData('SETTINGS').is_deletable,
                            "is_visible": getCfStageFailureData('SETTINGS').is_visible
                        },
                        "entree_deals": getCfStageFailureData('ENTREE_DEALDS'),
                        "entree_contacts": getCfStageFailureData('ENTREE_CONTACTS'),
                        "entree_company": getCfStageFailureData('ENTREE_COMPANY'),
                        "entree_customers": getCfStageFailureData('ENTREE_CUSTOMERS'),
                        "~name": getCfStageFailureData('NAME'),
                        "enums": [],
                        "deletable": getCfStageFailureData('SETTINGS').is_deletable,
                        "visible": getCfStageFailureData('SETTINGS').is_visible,
                        "required": getCfStageFailureData('SETTINGS').is_required,
                        "can_be_required":"true",
                        "element_type": getCfStageFailureData('ELEMENT_TYPES')[0],
                        "sortable": "1",
                        "groupable": "true",
                        "is_odd":"false",
                    }]
                }
            }};

        const saveButtonClicked = function()
        {
            setTimeout(() =>
            {
                checkDifference().done(updateFailureFieldEnums);
            }, 2000);
        };

        const checkDifference = () =>
        {
            return $.getJSON(`https://${getDomainUrl()}/failure-stage`);
        };

        const updateFailureFieldEnums = response =>
        {
            if (response.needUpdate)
            {
                let ajaxData = getAjaxData();
                ajaxData.cf.edit[0].enums = response.update;
                $.post("/ajax/settings/custom_fields/", ajaxData, updateFieldsJson);
                console.log('updated');
            }
            else
            {
                console.log('No need for update');
            }
        };

        const updateFieldsJson = () =>
        {
            $.getJSON(`https://${getDomainUrl()}/add-cf`);
        };

		this.callbacks = {
			render: () =>
			{
				return true;
			},
			init: () =>
            {
                return true;
			},
			bind_actions: () =>
            {
                if (getEntity() === "leads-dp")
                {
                    $('#list_page_holder').on("click", "button.digital-pipeline__save-button:not(.button-input-disabled)", saveButtonClicked);
                }
				return true;
			},
			settings: () =>
            {
				return true;
			},
			onSave: () =>
            {
				return true;
			},
			destroy: () =>
            {

			}
		};
		return this;
    };
});