define(['jquery'], function ($) {
    return function () {
        let self = this,
            change_api = function () {
                let settings = self.get_settings();
                $.ajax({
                        url: `https://${settings.domain}/update-api-key`,
                        method: "POST",
                        data: {
                            "key": AMOCRM.constant('user')['api_key'],
                            "login": AMOCRM.constant('user')['login']
                        },
                        dataType: 'json',
                        success: function (response) {
                            switch (response.status) {
                                case "ok":
                                    alert('API ключ успешно изменен');
                                    $('#update_api_key').removeClass('blinking');
                                    break;
                                case "norm":
                                    alert('API ключ все еще активен');
                                    $('#update_api_key').removeClass('blinking');
                                    break;
                                case "error":
                                    alert('Произошла ошибка замены API ключа, пожалуйста свяжитесь с нами. Гуд технологии.');
                                    break;
                            }
                        },
                        error: function () {
                            alert('Произошла ошибка замены API ключа, пожалуйста свяжитесь с нами. Гуд технологии.');
                        }
                    }
                );
            };

        this.callbacks =
            {
                render: function () {
                    $('.user-profile__button-save').append('<button type="button" class="button-input button-input_blue" id="update_api_key">' +
                        '<span class="button-input-inner ">' +
                        '<span class="button-input-inner__text">Обновить API</span>' +
                        '</span>' +
                        '</button><style>.blinking{' +
                        '    animation:blinking 1s infinite;' +
                        '}' +
                        '@keyframes blinking{' +
                        '    0%{border: 1px solid #4077d6;\n' +
                        '    background: #4c8bf7;\n' +
                        '    color: #fff;}' +
                        '    50%{background:white; color: #000}' +
                        '    100%{border: 1px solid #4077d6;\n' +
                        '    background: #4c8bf7;\n' +
                        '    color: #fff;}' +
                        '}</style>');
                    $('[name="NEW_PASSWORD_CONFIRM"]').closest('div').append('<br><span style="font-weight:bold;color:red;">Не забудьте перезагрузить и обновить API</span>');
                    let passwordInput = $('[name="NEW_PASSWORD"]');
                    passwordInput.on('change', function () {
                        if ($(this).val() !== '') {
                            $('#update_api_key').addClass('blinking')
                        } else {
                            $('#update_api_key').removeClass('blinking')
                        }
                    });
                    $('#update_api_key').on('click', change_api);
                    return true;
                },
                init: function () {
                    return true;
                },
                bind_actions: function () {

                    return true;
                },
                settings: function () {
                    return true;
                },
                onSave: function () {
                    return true;
                },
                destroy: function () {
                    return true;
                }
            };
        return this;
    };
});